# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for unconditional strategies in opponent's code
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D" if current_round > 1 else "C"
    if is_always_d:
        return "C" if current_round % 2 == 1 else "D"
    
    # Grim trigger logic
    if "D" in opp_history:
        return "D"
    
    # Phased strategy
    if current_round <= 3:
        return "C"
    elif current_round <= 7:
        return "C" if "D" not in opp_history else "D"
    else:
        if "D" not in opp_history:
            return "C" if current_round != 10 else "D"
        else:
            return "D"